/*********************************************************************
*              SEGGER MICROCONTROLLER GmbH & Co. KG                  *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 2011 SEGGER Microcontroller GmbH & Co. KG               *
*                                                                    *
* Internet: www.segger.com Support: support@segger.com               *
*                                                                    *
**********************************************************************
----------------------------------------------------------------------
File    : Main.c
Purpose : Implementation of the main() function of the sample project.
          Sends commands to the Cortex-M0 core of the LPC4350 and waits
          for reception response.
---------------------------END-OF-HEADER------------------------------
*/
#define MAIN_C
#include "Main.h"

/*********************************************************************
*
*       main
*/
void main(void) {
  int i;

  do {
    //
    // Send command to Cortex-M0 and wait for response
    // Until we received the response, we can resume execution
    //
    CMD_M4 = 1;
    do {
      if (RESPONSE_M0 == 0x2) {
        RESPONSE_M0 = 0;    // Reset response
        break;
      }
    } while(1);
  } while(1);
}
